function [speed, alpha, time] = run(u, port)

warning off serialport:serialport:ReadWarning

%% Initialization
% Sampling Time
Ts = 10e-3;

N = length(u);
time = zeros(1, N);
speed = zeros(1, N);
alpha = zeros(1,N);
%% Serial Initialization
utstart(port);                   % open COM port
utwrite([1 0 1]);
%% Initialize Experiment
for k = 2:N
    t = tic;
    utwrite(u(k)/2 + 0.5);
    [alpha(k), speed(k)] = utread;
    pauses(Ts, t);
    time(k) = time(k-1) + toc(t);
end
%make sure to put the 0 PWM before stopping

speed(1:10) = 0;
alpha(1:10) = 0;

utwrite([0 185/255 0]);

for i = 1:10
    utread;
end

warning on serialport:serialport:ReadWarning

utstop;
end

